using System;
using System.Collections.Generic;
using System.Text;
using KttK.HspDecompiler.Ax3ToAs.Data.Analyzer;
using KttK.HspDecompiler.Ax3ToAs.Data.Line;
namespace KttK.HspDecompiler.Ax3ToAs.Data
{
	/// <summary>
	/// TokenFactory
	/// </summary>
	class SyntacticAnalyzer
	{
		int readingLine = 0;
		internal List<LogicalLine> Analyze(TokenCollection stream, AxData data)
		{
			List<LogicalLine> ret = new List<LogicalLine>();
			subAnalyzePreprocessor(ret, data);
			readingLine = ret.Count;
			//\
			while (!stream.NextIsEndOfStream)
			{
				System.Windows.Forms.Application.DoEvents();
				System.Threading.Thread.Sleep(0);
				readingLine++;
				LogicalLine line = LogicalLineFactory.GetCodeToken(stream.GetLine());
				if (line != null)
					ret.Add(line);
			}

			//S[Xg̍폜 foreach2Ƃstop̌gotoƂB
			//repeatȂǂ̌ɏo郉x͍\͂ō폜
			for (int i = 0; i < ret.Count; i++)
			{
				if (ret[i].HasFlagIsGhost)
					ret[i].Visible = false;
				if ( (ret[i].HasFlagGhostGoto) && (i != (ret.Count -1) ) )
					ret[i + 1].Visible = false;
			}
			ret = ret.FindAll(IsVisible);
			for (int i = 0; i < ret.Count; i++)
			{
				if(!ret[i].CheckRpn())
					ret[i].AddError("F̕ϊɎs");
			}


			//subAnalyzeScoopAsubAnalyzeLabel̏ł
			//if(value){
			//@``
			//}
			//*label
			//else{
			//@``
			//}
			//ƂȂɃG[
			//ȂsubAnalyzeLabelAsubAnalyzeScoop̏ł
			//if(value){
			//@``
			//*label
			//}
			//return
			//ƂȂĂ݂ƂȂB
			//subAnalyzeScoopAsubAnalyzeLabel̏ōsAsubAnalyzeLabel̍ۂɒオelse߂ŒOScoopEndȂ߂B

			subAnalyzeScoop(ret);
			subAnalyzeLabel(ret,data);
			

			//^u`]ȍs̍폜s
			int tabCount = 1;
			for (int i = 0; i < ret.Count; i++)
			{
				if (ret[i].TabDecrement)
					tabCount--;
				ret[i].TabCount = tabCount;
				if (ret[i].TabIncrement)
					tabCount++;
			}


			for (int i = 0; i < ret.Count; i++)
			{
				if (ret[i].GetErrorMes().Count != 0)
					foreach (string errMes in ret[i].GetErrorMes())
						global::KttK.HspDecompiler.HspConsole.Warning(errMes, i + 1);

			}
			ret[ret.Count - 1].Visible = false;//Ɏstop̍폜
			ret = ret.FindAll(IsVisible);
			return ret;


		}

		private void subAnalyzePreprocessor(List<LogicalLine> ret, AxData data)
		{
			if (data.Runtime != null)
			{
				ret.Add(new PreprocessorDeclaration(data.Runtime));
				ret.Add(new CommentLine());
			}
			if (data.Modules.Count != 0)
			{
				foreach (Function module in data.Modules)
				{
					LogicalLine line = new PreprocessorDeclaration(module);
					line.AddError("deHSP̏o͂#structHSP̌JĂ錾dlɂ͊܂܂܂");
					ret.Add(line);
					//ret.Add(new EndOfModule());//#globalCl
				}

			}


			foreach (Usedll dll in data.Usedlls)
			{
				ret.Add(new PreprocessorDeclaration(dll));
				List<Function> funcs = dll.GetFunctions();
				if(funcs != null)
					foreach(Function func in funcs)
						ret.Add(new PreprocessorDeclaration(func));
				ret.Add(new CommentLine());
			}

			foreach (PlugIn plugin in data.PlugIns)
			{
				ret.Add(new PreprocessorDeclaration(plugin));
				Dictionary<int, Cmd> cmds = plugin.GetCmds();
				foreach (Cmd cmd in cmds.Values)
				{
					ret.Add(new PreprocessorDeclaration(cmd));
				}
				ret.Add(new CommentLine());
			}
		}


		/// <summary>
		/// if,elseXR[v̏I_߂B
		/// </summary>
		/// <param defaultName="ret"></param>
		private void subAnalyzeScoop(List<LogicalLine> ret)
		{			
			for (int i = 0; i < ret.Count; i++)
			{
				//ifelseȊO͊֌WȂB
				IfStatement scoopStart = ret[i] as IfStatement;
				if (scoopStart == null)
					continue;
				if (scoopStart.JumpToOffset < 0)
				{
					scoopStart.ScoopEndIsDefined = false;
					scoopStart.AddError("s:I_ۑĂ܂");
					continue;
				}
				//܂ns(Jump̂Ƃѐ)TB
				//s̓rɒnĂ͂ȂȂB
				//TokenOffset0xFFFF𒴂ꍇAHSP3.0a̓Io[t[NARpC͒ʂB
				//s̓rɒn̂͂̂Ƃ炢B
				//<<2007/4/17ǋL>>
				//if (``){
				//ƂāA}ȂꍇAѐ悪0ɃZbgB̂Ƃs̓rig̓rɂȂjɒn悤
				int jumpToOffset = scoopStart.JumpToOffset;
				int jumpToLineNo = -1;
				for (int j = (i + 1); j < ret.Count; j++)
				{
					if (ret[j].TokenOffset == jumpToOffset)
					{
						jumpToLineNo = j;
						break;
					}
					//s߂炨܂B
					if ((ret[j].TokenOffset != -1) && (ret[j].TokenOffset > jumpToOffset))
					{
						jumpToLineNo = -2;
						break;
					}
				}
				if (jumpToLineNo == -1)
				{
					scoopStart.ScoopEndIsDefined = false;
					scoopStart.AddError(string.Format("s:{0:X08}:XR[v̏I肪R[hI[𒴂Ă܂",jumpToOffset));
					continue;
				}
				if (jumpToLineNo == -2)
				{
					scoopStart.ScoopEndIsDefined = false;
					scoopStart.AddError(string.Format("s:{0:X08}:XR[v̏I肪s̓rł", jumpToOffset));
					continue;
				}
				//ʏ͒n̒OScoopEnd}B
				//ifelseɔԏꍇAjumpelse̒̍sɂȂĂ̂łɂЂƂ̂ڂKvB
				IfStatement elseStatement = ret[jumpToLineNo - 1] as IfStatement;
				if (elseStatement != null)
					if ((scoopStart.isIfStatement) && (elseStatement.isElseStatement))
						jumpToLineNo--;
				ret.Insert(jumpToLineNo, new ScoopEnd());
				scoopStart.ScoopEndIsDefined = true;
			}
		}

		/// <summary>
		/// xǉ
		/// </summary>
		/// <param defaultName="ret"></param>
		/// <param defaultName="data"></param>
		private void subAnalyzeLabel(List<LogicalLine> ret, AxData data)
		{
			foreach (LogicalLine line in ret)
				line.CheckLabel();
			data.DeleteInvisibleLables();
			data.RenameLables();
			int i = 0;
			foreach (Label label in data.Labels)
			{
				if (label.TokenOffset == -1)
					continue;
				while ((i < ret.Count) && ((ret[i].TokenOffset == -1) || (label.TokenOffset > ret[i].TokenOffset)))
				{
					i++;
				}

				//if(value){
				//@``
				//}
				//*label
				//else{
				//@``
				//}
				//ƂȂ̂鏈B
				//悤ƂĂꏊ(i)else߂̒OScoopEnd̒ȂScoopEnd̑OɈړB
				if ((i> 0) &&(ret[i] is IfStatement))
				{
					IfStatement ifStatement = ret[i] as IfStatement;
					if ((ret[i - 1] is ScoopEnd) && (ifStatement.isElseStatement))
					{
						i--;
					}

				}
				ret.Insert(i,new PreprocessorDeclaration(label));
				continue;
			}
		}

		private bool IsVisible(LogicalLine line)
		{
			return line.Visible;
		}



	}
}
